use crate::Route;
use dioxus::prelude::*;

const NAVBAR_CSS: Asset = asset!("/assets/styling/navbar.css");

/// The Navbar component that will be rendered on all pages of our app since every page is under the layout.
///
/// This layout component wraps the UI in a common navbar. The contents of the routes will be rendered under the outlet inside this component
#[component]
pub fn Navbar() -> Element {
    rsx! {
        // The `Outlet` component is used to render the next component inside the layout. In this case, it will render component depending on the current route.
        Outlet::<Route> {}

        document::Link { rel: "stylesheet", href: NAVBAR_CSS }

        div { id: "navbar",
            Link { id: "navbar-item", to: Route::TransactionAccounts {}, "Transaction Accounts" }
            Link { id: "navbar-item", to: Route::TransactionAccounts {}, "Transaction Accounts" }

            div { class: "fab-container",
                button { class: "fab", "+" }
            }

            Link { id: "navbar-item", to: Route::TransactionAccounts {}, "Transaction Accounts" }
            Link { id: "navbar-item", to: Route::TransactionAccounts {}, "Transaction Accounts" }
        }
    }
}
