import { createFeatureSelector, createSelector } from '@ngrx/store';
import { CategoryState, categoryStateKey } from './category.state';

export const getCategoriesState = createFeatureSelector<CategoryState>(categoryStateKey);

const getCategories = createSelector(getCategoriesState, (state) => state.categories);
const effectWorking = createSelector(getCategoriesState, (state) => state.effectWorking);

export const categoriesStateQuery = {
  effectWorking,
  getCategories
};
