import { ActionReducerMap } from '@ngrx/store';
import { QuestionState } from './question-state/question.state';
import { reducer as questionReducer } from './question-state/question.reducers';
import { CategoryState } from './category-state/category.state';
import { reducer as categoryReducer } from './category-state/category.reducers';

export interface State {
  question: QuestionState;
  category: CategoryState;
}

export const reducers: ActionReducerMap<State, any> = {
  question: questionReducer,
  category: categoryReducer
};
