import { Component, EventEmitter, OnInit, Output } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';

import { CategoryFacadeService } from 'src/app/core/state/category-facade.service';
import { ButtonType } from 'src/app/shared-app/components/generic/button/button.models';
import { AskQuestionRequest } from 'src/app/shared-app/models';

@Component({
  selector: 'app-ask-question-shared',
  templateUrl: './ask-question-shared.component.html',
  styleUrls: ['./ask-question-shared.component.scss']
})
export class AskQuestionSharedComponent implements OnInit {
  @Output() askQuestion = new EventEmitter<AskQuestionRequest>();

  public titleForm = new FormControl('', [Validators.required, Validators.maxLength(500)]);
  public textForm = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  public categoriesForm = new FormControl([]);
  public questionFormGroup: FormGroup;
  public ButtonType = ButtonType;
  public categoriesList$ = this.categoriesFacade.getCategories();

  constructor(private categoriesFacade: CategoryFacadeService, private router: Router) {
    this.questionFormGroup = new FormGroup({
      title: this.titleForm,
      text: this.textForm,
      categories: this.categoriesForm
    });
  }

  ngOnInit(): void {}

  public askQuestionEmit(): void {
    const body = new AskQuestionRequest(this.titleForm.value, this.textForm.value, this.categoriesForm.value);
    this.askQuestion.emit(body);
  }
}
