import { Component, EventEmitter, OnInit, Output } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import * as moment from 'moment';

import { CategoryFacadeService } from 'src/app/core/state/category-facade.service';
import { ButtonType } from 'src/app/shared-app/components/generic/button/button.models';
import {
  AskQuestionRequest,
  QuestionCategoryQuestionStateViewModel,
  QuestionStateViewModel,
  StudentQuestionStateViewModel
} from 'src/app/shared-app/models';

@Component({
  selector: 'app-ask-question-shared',
  templateUrl: './ask-question-shared.component.html',
  styleUrls: ['./ask-question-shared.component.scss']
})
export class AskQuestionSharedComponent implements OnInit {
  @Output() askQuestion = new EventEmitter<AskQuestionRequest>();

  public previewQuestion?: QuestionStateViewModel;

  public titleForm = new FormControl('', [Validators.required, Validators.maxLength(500)]);
  public textForm = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  public categoriesForm = new FormControl([]);
  public questionFormGroup: FormGroup;
  public ButtonType = ButtonType;
  public categoriesList$ = this.categoriesFacade.getCategories();

  constructor(private categoriesFacade: CategoryFacadeService) {
    this.questionFormGroup = new FormGroup({
      title: this.titleForm,
      text: this.textForm,
      categories: this.categoriesForm
    });
  }

  ngOnInit(): void {
    this.questionFormGroup.valueChanges.subscribe((x) => {
      const student = new StudentQuestionStateViewModel('', '', '', 0);
      const categories = this.categoriesForm.value.map(
        (category: any) => new QuestionCategoryQuestionStateViewModel('', category.name, category.translatedName)
      );

      this.previewQuestion = new QuestionStateViewModel(
        '',
        this.titleForm.value,
        this.textForm.value,
        moment(),
        0,
        moment(),
        student,
        [],
        categories,
        null
      );
    });
  }

  public askQuestionEmit(): void {
    this.askQuestion.emit(
      new AskQuestionRequest(
        this.titleForm.value,
        this.textForm.value,
        this.categoriesForm.value.map((x: any) => x.uid)
      )
    );
  }
}
