import { Component, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';

@Component({
  selector: 'app-text-editor',
  templateUrl: './text-editor.component.html',
  styleUrls: ['./text-editor.component.scss']
})
export class TextEditorComponent implements OnInit, OnChanges {
  @Input() textForm = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  @Input() text?: string;
  @Input() readonly = false;
  @Input() configuration: Record<string, any> = {
    menubar: false,
    plugins: [
      'advlist autolink lists link image charmap print preview anchor',
      'searchreplace visualblocks code fullscreen',
      'insertdatetime media table paste code help wordcount'
    ],
    toolbar:
      'undo redo | formatselect | bold italic backcolor | code | \
      alignleft aligncenter alignright alignjustify | \
      bullist numlist outdent indent | removeformat | help'
  };

  constructor() {}
  ngOnChanges(changes: SimpleChanges): void {
    this.textForm.setValue(this.text);
  }

  ngOnInit(): void {}
}
