﻿using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Helpers;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.UnitOfWork;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Questioning.EventHandlers
{
    public class NotifyStudentHisQuestionIsAnswered : IEventHandler<QuestionAnsweredEvent>
    {
        public NotifyStudentHisQuestionIsAnswered(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task Handle(QuestionAnsweredEvent notification, CancellationToken cancellationToken)
        {
            var student = await UnitOfWork.Students.GetByUidAsync(notification.StudentUid);
            var question = await UnitOfWork.Questions.GetByUidAsync(notification.QuestionUid);

            if (student == null)
            {
                return;
            }

            if (question == null)
            {
                return;
            }

            var studentNotification = new StudentNotification()
            {
                StudentFk = student.Id,
                QuestionUid = notification.QuestionUid,
                Text = $"Your question {question.Title} has been answered"
            };

            UnitOfWork.StudentNotifications.Add(studentNotification);
            await UnitOfWork.SaveAsync();
        }
    }
}
