﻿#nullable enable

using System;
using System.Collections.Generic;


namespace FinkiChattery.Contracts.User
{
    public class SelfUserResponse
    {
        public SelfUserResponse(StudentSelfResponse? student = null, TeacherSelfResponse? teacher = null, ModeratorSelfResponse? moderator = null)
        {
            Student = student;
            Teacher = teacher;
            Moderator = moderator;
        }

        public StudentSelfResponse? Student { get; }
        public TeacherSelfResponse? Teacher { get; }
        public ModeratorSelfResponse? Moderator { get; }
    }

    public class StudentSelfResponse
    {
        public StudentSelfResponse(Guid uid, long applicationUserId, string index, long reputation, string imageUrl, IEnumerable<StudentQuestionResponse> questions, IEnumerable<StudentTeamResponse> teams, IEnumerable<StudentNotificationResponse> notifications)
        {
            Uid = uid;
            ApplicationUserId = applicationUserId;
            Index = index;
            Reputation = reputation;
            ImageUrl = imageUrl;
            Questions = questions;
            Teams = teams;
            Notifications = notifications;
        }

        public Guid Uid { get; }
        public long ApplicationUserId { get; }
        public string Index { get; }
        public long Reputation { get; }
        public string ImageUrl { get; }
        public IEnumerable<StudentQuestionResponse> Questions { get; }
        public IEnumerable<StudentTeamResponse> Teams { get; }
        public IEnumerable<StudentNotificationResponse> Notifications { get; }
    }

    public class StudentNotificationResponse
    {
        public StudentNotificationResponse(Guid uid, string text, DateTime createdOn, Guid questionUid)
        {
            Uid = uid;
            Text = text;
            CreatedOn = createdOn;
            QuestionUid = questionUid;
        }

        public Guid Uid { get; }
        public string Text { get; }
        public DateTime CreatedOn { get; }
        public Guid QuestionUid { get; }
    }

    public class StudentQuestionResponse
    {
        public StudentQuestionResponse(Guid questionUid, string title)
        {
            QuestionUid = questionUid;
            Title = title;
        }

        public Guid QuestionUid { get; }
        public string Title { get; }
    }

    public class StudentTeamResponse
    {
        public StudentTeamResponse(Guid teamUid, string name)
        {
            TeamUid = teamUid;
            Name = name;
        }

        public Guid TeamUid { get; }
        public string Name { get; }
    }

    public class ModeratorSelfResponse
    {
        public ModeratorSelfResponse(Guid uid, long applicationUserId)
        {
            Uid = uid;
            ApplicationUserId = applicationUserId;
        }

        public Guid Uid { get; }
        public long ApplicationUserId { get; }
    }

    public class TeacherSelfResponse
    {
        public TeacherSelfResponse(Guid uid, long applicationUserId, IEnumerable<TeacherTeamResponse> teams)
        {
            Uid = uid;
            ApplicationUserId = applicationUserId;
            Teams = teams;
        }

        public Guid Uid { get; }
        public long ApplicationUserId { get; }
        public IEnumerable<TeacherTeamResponse> Teams { get; }
    }

    public class TeacherTeamResponse
    {
        public TeacherTeamResponse(Guid teamUid, string name)
        {
            TeamUid = teamUid;
            Name = name;
        }

        public Guid TeamUid { get; }
        public string Name { get; }
    }
}
