﻿CREATE TABLE [dbo].[StudentNotification]
(
	[Id]        BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]       UNIQUEIDENTIFIER NOT NULL,
	[StudentFk] BIGINT           NOT NULL, 
    [Text]      NVARCHAR(500)    NOT NULL,
    [QuestionUid] UNIQUEIDENTIFIER NOT NULL, 
    [CreatedOn] SMALLDATETIME NOT NULL, 
    CONSTRAINT [PK_StudentNotification] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_StudentNotification_Student_StudentFk] FOREIGN KEY ([StudentFk]) REFERENCES [dbo].[Student] ([Id]),
)

GO
CREATE NONCLUSTERED INDEX [IX_StudentNotification_StudentFk]
    ON [dbo].[StudentNotification]([StudentFk] ASC);