﻿using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using System;

namespace FinkiChattery.Persistence.Configurations
{
    public class StudentNotificationConfig : BaseConfig<StudentNotification>
    {
        public StudentNotificationConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<StudentNotification> builder)
        {
            base.Configure(builder);

            builder.ToTable("StudentNotification", Schema);

            builder.Property(x => x.Text).HasColumnName(@"Text").HasColumnType("nvarchar").IsRequired().HasMaxLength(500);
            builder.Property(x => x.StudentFk).HasColumnName(@"StudentFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.CreatedOn).HasColumnName(@"CreatedOn").HasColumnType("smalldatetime").IsRequired().HasConversion(v => v, v => DateTime.SpecifyKind(v, DateTimeKind.Utc)); ;
            builder.Property(x => x.QuestionUid).HasColumnName(@"QuestionUid").HasColumnType("uniqueidentifier").IsRequired();

            builder.HasOne(x => x.Student).WithMany(x => x.StudentNotifications).HasForeignKey(x => x.StudentFk).OnDelete(DeleteBehavior.Restrict);
        }
    }
}
