import { HttpErrorResponse } from '@angular/common/http';
import { Action } from '@ngrx/store';
import { CategoryStateViewModel } from 'src/app/shared-app/models';
import { CategoryStateResponse } from './category-state.models';

export enum CategoryActionTypes {
  GetCategoriesState = '[Category] Get state',
  GetCategoriesStateSuccess = '[Category] Get state success',
  EffectStartedWorking = '[Category] Effect Started Working',
  EffectFinishedWorking = '[Category] Effect Finished Working',
  EffectFinishedWorkingError = '[Category] Effect Finished Working error'
}

export class GetCategoriesState implements Action {
  readonly type = CategoryActionTypes.GetCategoriesState;

  constructor() {}
}

export class GetCategoriesStateSuccess implements Action {
  readonly type = CategoryActionTypes.GetCategoriesStateSuccess;

  constructor(public payload: CategoryStateViewModel[]) {}
}

export class EffectStartedWorking implements Action {
  readonly type = CategoryActionTypes.EffectStartedWorking;

  constructor() {}
}

export class EffectFinishedWorking implements Action {
  readonly type = CategoryActionTypes.EffectFinishedWorking;

  constructor() {}
}

export class EffectFinishedWorkingError implements Action {
  readonly type = CategoryActionTypes.EffectFinishedWorkingError;

  constructor(public payload: HttpErrorResponse) {}
}

export type CategoryAction = GetCategoriesStateSuccess | EffectStartedWorking | EffectFinishedWorking | EffectFinishedWorkingError;
