import { Injectable } from '@angular/core';
import { Actions, createEffect, ofType } from '@ngrx/effects';
import { catchError, switchMap } from 'rxjs/operators';

import { BaseApiService } from 'src/app/shared-app/services/base-api.service';
import { QuestionStateResponse } from './question-state.models';
import {
  EffectFinishedWorking,
  EffectFinishedWorkingError,
  GetQuestionState,
  GetQuestionStateSuccess,
  QuestionActionTypes
} from './question.actions';
import { QuestionMapper } from './question.mapper';

@Injectable({
  providedIn: 'root'
})
export class QuestionEffects {
  constructor(private actions$: Actions, private api: BaseApiService) {}

  getQuestionState$ = createEffect(() => {
    return this.actions$.pipe(
      ofType<GetQuestionState>(QuestionActionTypes.GetQuestionState),
      switchMap((action) => {
        return this.api.get<QuestionStateResponse>(`v1/questions/${action.questionUid}`).pipe(
          switchMap((state) => [new GetQuestionStateSuccess(QuestionMapper.ToQuestionStateViewModel(state)), new EffectFinishedWorking()]),
          catchError((err) => [new EffectFinishedWorkingError(err)])
        );
      })
    );
  });
}
