import { createFeatureSelector, createSelector } from '@ngrx/store';
import { QuestionState, questionStateKey } from './question.state';

export const getQuestionState = createFeatureSelector<QuestionState>(questionStateKey);

const getQuestion = createSelector(getQuestionState, (state) => state.question);
const effectWorking = createSelector(getQuestionState, (state) => state.effectWorking);

export const questionStateQuery = {
  effectWorking,
  getQuestion
};
