import { HttpErrorResponse } from '@angular/common/http';
import { Action } from '@ngrx/store';

import { PreviewQuestionViewModel, QuestionStateViewModel } from 'src/app/shared-app/models';
import { PreviewQuestionResponse } from './question-state.models';

export enum QuestionActionTypes {
  GetQuestionState = '[Question] Get state',
  GetQuestionStateSuccess = '[Question] Get state success',
  GetPreviewQuestionsLatest = '[Question] Get preview questions Latest',
  GetPreviewQuestionsLatestSuccess = '[Question] Get preview questions Latest Success',
  GetPreviewQuestionsPopular = '[Question] Get preview questions Popular',
  GetPreviewQuestionsPopularSuccess = '[Question] Get preview questions Popular Success',
  EffectStartedWorking = '[Question] Effect Started Working',
  EffectFinishedWorking = '[Question] Effect Finished Working',
  EffectFinishedWorkingError = '[Question] Effect Finished Working error'
}

export class GetQuestionState implements Action {
  readonly type = QuestionActionTypes.GetQuestionState;

  constructor(public questionUid: string) {}
}

export class GetQuestionStateSuccess implements Action {
  readonly type = QuestionActionTypes.GetQuestionStateSuccess;

  constructor(public payload: QuestionStateViewModel) {}
}

export class GetPreviewQuestionsLatest implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsLatest;

  constructor() {}
}

export class GetPreviewQuestionsLatestSuccess implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsLatestSuccess;

  constructor(public payload: PreviewQuestionViewModel[]) {}
}

export class GetPreviewQuestionsPopular implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsPopular;

  constructor() {}
}

export class GetPreviewQuestionsPopularSuccess implements Action {
  readonly type = QuestionActionTypes.GetPreviewQuestionsPopularSuccess;

  constructor(public payload: PreviewQuestionViewModel[]) {}
}

export class EffectStartedWorking implements Action {
  readonly type = QuestionActionTypes.EffectStartedWorking;

  constructor() {}
}

export class EffectFinishedWorking implements Action {
  readonly type = QuestionActionTypes.EffectFinishedWorking;

  constructor() {}
}

export class EffectFinishedWorkingError implements Action {
  readonly type = QuestionActionTypes.EffectFinishedWorkingError;

  constructor(public payload: HttpErrorResponse) {}
}

export type QuestionAction =
  | GetQuestionStateSuccess
  | GetPreviewQuestionsLatestSuccess
  | GetPreviewQuestionsPopularSuccess
  | EffectStartedWorking
  | EffectFinishedWorking
  | EffectFinishedWorkingError;
