import { HttpErrorResponse } from '@angular/common/http';
import { PreviewQuestionViewModel, QuestionStateViewModel } from 'src/app/shared-app/models';

export const questionStateKey = 'question';

export interface QuestionState {
  question: QuestionStateViewModel | null;
  previewQuestionsLatest: PreviewQuestionViewModel[];
  previewQuestionsPopular: PreviewQuestionViewModel[];
  effectWorking: boolean | HttpErrorResponse;
}

export const initialState: QuestionState = {
  question: null,
  previewQuestionsLatest: [],
  previewQuestionsPopular: [],
  effectWorking: false
};
