import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';

@Component({
  selector: 'app-student-card',
  templateUrl: './student-card.component.html',
  styleUrls: ['./student-card.component.scss']
})
export class StudentCardComponent implements OnInit {
  @Input() imageUrl: string | undefined;
  @Input() indexNumber: string | undefined;
  @Input() uid!: string;
  @Input() reputation: number | undefined;
  @Input() subtitle: string | undefined;
  @Output() studentCardClicked = new EventEmitter<string>();

  constructor() {}

  ngOnInit(): void {}

  cardClicked(): void {
    this.studentCardClicked.emit(this.uid);
  }
}
