import { QuestionAction, QuestionActionTypes } from './question.actions';
import { initialState, QuestionState } from './question.state';

export function reducer(state = initialState, action: QuestionAction): QuestionState {
  switch (action.type) {
    case QuestionActionTypes.GetQuestionStateSuccess:
      return {
        ...state,
        question: action.payload
      };
    case QuestionActionTypes.GetPreviewQuestionsLatestSuccess:
      return {
        ...state,
        previewQuestionsLatest: action.payload
      };
    case QuestionActionTypes.GetPreviewQuestionsPopularSuccess:
      return {
        ...state,
        previewQuestionsPopular: action.payload
      };
    case QuestionActionTypes.GetSearchQuestionsSuccess:
      return {
        ...state,
        searchQuestions: action.payload,
        searchQuestionsQuery: action.query
      };
    case QuestionActionTypes.EffectStartedWorking: {
      return {
        ...state,
        effectWorking: true
      };
    }

    case QuestionActionTypes.EffectFinishedWorking: {
      return {
        ...state,
        effectWorking: false
      };
    }

    case QuestionActionTypes.EffectFinishedWorkingError: {
      return {
        ...state,
        effectWorking: action.payload
      };
    }

    default: {
      return {
        ...state
      };
    }
  }
}
