import { Component, OnInit } from '@angular/core';
import { FormControl } from '@angular/forms';
import { Router } from '@angular/router';
import { CategoryFacadeService } from 'src/app/core/state/category-facade.service';
import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';
import { CategoryStateViewModel, PreviewQuestionsOrderEnum } from 'src/app/shared-app/models';

@Component({
  selector: 'app-questions-preview-general',
  templateUrl: './questions-preview-general.component.html',
  styleUrls: ['./questions-preview-general.component.scss']
})
export class QuestionsPreviewGeneralComponent implements OnInit {
  categories?: CategoryStateViewModel[];
  previewQuestions$ = this.questionFacade.getPreviewQuestionsLatest();
  QuestionsSortBy = PreviewQuestionsOrderEnum;
  questionsSortByForm = new FormControl(PreviewQuestionsOrderEnum.Latest);

  constructor(private categoriesFacade: CategoryFacadeService, private questionFacade: QuestionFacadeService, private router: Router) {}

  ngOnInit(): void {
    this.categoriesFacade.fetchCategories();
    this.questionFacade.fetchPreviewQuestions(PreviewQuestionsOrderEnum.Latest);
    this.questionsSortByForm.valueChanges.subscribe((value: PreviewQuestionsOrderEnum) => {
      this.questionFacade.fetchPreviewQuestions(value);

      if (value === PreviewQuestionsOrderEnum.Latest) {
        this.previewQuestions$ = this.questionFacade.getPreviewQuestionsLatest();
      } else if (value === PreviewQuestionsOrderEnum.Popular) {
        this.previewQuestions$ = this.questionFacade.getPreviewQuestionsPopular();
      }
    });
  }

  goToQuestion(uid: string): void {
    this.router.navigateByUrl(`questioning/${uid}`);
  }

  routeToSearch(): void {
    this.router.navigateByUrl(`questioning/search`);
  }
}
