import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { QuestionPreviewGeneralComponent } from './components/question-preview-general/question-preview-general.component';
import { QuestioningGeneralComponent } from './components/questioning-general/questioning-general.component';
import { QuestionsPreviewGeneralComponent } from './components/questions-preview-general/questions-preview-general.component';
import { QuestionsSearchComponent } from './components/questions-search/questions-search.component';

const routes: Routes = [
  {
    component: QuestioningGeneralComponent,
    path: '',
    children: [
      {
        path: 'preview',
        pathMatch: 'full',
        component: QuestionsPreviewGeneralComponent
      },
      {
        path: 'search',
        pathMatch: 'full',
        component: QuestionsSearchComponent
      },
      {
        path: ':questionUid',
        component: QuestionPreviewGeneralComponent
      }
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class QuestioningRoutingModule {}
