﻿using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.Helpers;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class VoteAnswerByStudentIsValid : AsyncValidatorBase
    {
        public VoteAnswerByStudentIsValid(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }
        private VoteType _voteType { get; set; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var dto = (VoteAnswerByStudentIsValidDto)context.PropertyValue;

            _voteType = dto.VoteType;

            return dto.VoteType switch
            {
                VoteType.Upvote => !await UnitOfWork.Votes.StudentHasUpvotedAnswer(dto.AnswerUid, CurrentUser.Id),
                VoteType.Downvote => !await UnitOfWork.Votes.StudentHasDownvotedAnswer(dto.AnswerUid, CurrentUser.Id),
                _ => !await UnitOfWork.Votes.StudentHasUpvotedAnswer(dto.AnswerUid, CurrentUser.Id),
            };
        }

        protected override string GetDefaultMessageTemplate()
        {
            return _voteType switch
            {
                VoteType.Upvote => QuestioningErrorCodes.AnswerAlreadyUpvoted,
                VoteType.Downvote => QuestioningErrorCodes.AnswerAlreadyDownvoted,
                _ => QuestioningErrorCodes.AnswerAlreadyUpvoted
            };
        }
    }
}
