﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class VoteAnswerValidator : AbstractValidator<VoteAnswerCommand>
    {
        public VoteAnswerValidator(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => x).SetValidator(new StudentHasGoodReputationAndCanVoteAndAnswer(unitOfWork, currentUser));
            RuleFor(x => new VoteAnswerByStudentIsValidDto(x.VoteType, x.AnswerUid)).SetValidator(new VoteAnswerByStudentIsValid(unitOfWork, currentUser));
        }
    }
}
