﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Repositories;
using System;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.UnitOfWork
{
    public class UnitOfWork : IUnitOfWork
    {
        private QuestionRepo _questions;
        private CategoriesRepo _categories;
        private StudentRepo _students;
        private TeamRepo _teams;
        private VoteRepo _votes;
        private AnswerRepo _answers;

        public UnitOfWork(ApplicationDbContext dbContext)
        {
            DbContext = dbContext;
        }

        public ICategoriesRepo Categories
        {
            get
            {
                if (_categories == null)
                {
                    _categories = new CategoriesRepo(DbContext);
                }

                return _categories;
            }
        }

        public IQuestionRepo Questions
        {
            get
            {
                if (_questions == null)
                {
                    _questions = new QuestionRepo(DbContext);
                }

                return _questions;
            }
        }

        public IStudentRepo Students
        {
            get
            {
                if (_students == null)
                {
                    _students = new StudentRepo(DbContext);
                }

                return _students;
            }
        }

        public ITeamRepo Teams
        {
            get
            {
                if (_teams == null)
                {
                    _teams = new TeamRepo(DbContext);
                }

                return _teams;
            }
        }

        public IVoteRepo Votes
        {
            get
            {
                if (_votes == null)
                {
                    _votes = new VoteRepo(DbContext);
                }

                return _votes;
            }
        }

        public IAnswerRepo Answers
        {
            get
            {
                if (_answers == null)
                {
                    _answers = new AnswerRepo(DbContext);
                }

                return _answers;
            }
        }

        public ApplicationDbContext DbContext { get; }

        public async Task<int> SaveAsync()
        {
            return await DbContext.SaveChangesAsync();
        }

        #region IDisposable Support
        bool DisposedValue { get; set; }

        protected virtual void Dispose(bool disposing)
        {
            if (!DisposedValue)
            {
                if (disposing)
                {
                    DbContext.Dispose();
                }

                DisposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        #endregion
    }
}
