import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { AuthCallbackComponent } from './auth-callback/auth-callback.component';
import { AuthorizedGuard } from './core/guards/authorized.guard';

const routes: Routes = [
  {
    path: 'questioning',
    canActivate: [AuthorizedGuard],
    loadChildren: () => import('./modules/questioning/questioning.module').then((x) => x.QuestioningModule)
  },
  {
    path: 'auth-callback',
    pathMatch: 'full',
    component: AuthCallbackComponent
  },
  {
    path: '',
    pathMatch: 'full',
    redirectTo: 'questioning/preview'
  },
  {
    path: '**',
    redirectTo: 'questioning/preview'
  }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule {}
