import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';

import { CategoryFacadeService } from 'src/app/core/state/category-facade.service';
import { ButtonType } from 'src/app/shared-app/components/generic/button/button.models';
import { AskQuestionRequest } from '../../models/questioning-request.models';
import { QuestioningApiService } from '../../services/questioning-api.service';

@Component({
  selector: 'app-ask-question',
  templateUrl: './ask-question.component.html',
  styleUrls: ['./ask-question.component.scss']
})
export class AskQuestionComponent implements OnInit {
  public titleForm = new FormControl('', [Validators.required, Validators.maxLength(500)]);
  public textForm = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  public categoriesForm = new FormControl([]);
  public questionFormGroup: FormGroup;
  public ButtonType = ButtonType;
  public categoriesList$ = this.categoriesFacade.getCategories();

  constructor(private api: QuestioningApiService, private categoriesFacade: CategoryFacadeService, private router: Router) {
    this.questionFormGroup = new FormGroup({
      title: this.titleForm,
      text: this.textForm,
      categories: this.categoriesForm
    });
  }

  ngOnInit(): void {}

  public askQuestion(): void {
    const body = new AskQuestionRequest(this.titleForm.value, this.textForm.value, this.categoriesForm.value);
    this.api.askQuestion(body).subscribe((questionUid) => {
      this.router.navigateByUrl(`questioning/${questionUid}`);
    });
  }
}
