import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { BaseApiService } from 'src/app/shared-app/services/base-api.service';
import { AskQuestionRequest } from '../models/questioning-request.models';

@Injectable({
  providedIn: 'root'
})
export class QuestioningApiService extends BaseApiService {
  constructor(protected http: HttpClient) {
    super(http);
  }

  askQuestion(body: AskQuestionRequest): Observable<string> {
    return this.post('v1/questions', body);
  }
}
