import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { ButtonType } from '../button/button.models';

export enum VoteType {
  Upvote,
  Downvote
}

@Component({
  selector: 'app-vote',
  templateUrl: './vote.component.html',
  styleUrls: ['./vote.component.scss']
})
export class VoteComponent implements OnInit {
  @Input() voteCount: number | undefined;
  @Input() correct = false;
  @Output() voteClicked = new EventEmitter<VoteType>();

  VoteType = VoteType;
  ButtonType = ButtonType;

  constructor() {}

  ngOnInit(): void {}

  public voted(voteType: VoteType): void {
    this.voteClicked.emit(voteType);
  }
}
