﻿CREATE TABLE [dbo].[QuestionCategory] (
    [Id]         BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]        UNIQUEIDENTIFIER NOT NULL,
    [QuestionFk] BIGINT           NOT NULL,
    [CategoryFk] BIGINT           NOT NULL,
    CONSTRAINT [PK_QuestionCategory] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_QuestionCategory_Category_QuestionFk] FOREIGN KEY ([QuestionFk]) REFERENCES [dbo].[Category] ([Id]),
    CONSTRAINT [FK_QuestionCategory_Question_QuestionFk] FOREIGN KEY ([QuestionFk]) REFERENCES [dbo].[Question] ([Id])
);


GO
CREATE NONCLUSTERED INDEX [IX_QuestionCategory_QuestionFk]
    ON [dbo].[QuestionCategory]([QuestionFk] ASC);

