﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using FinkiChattery.Persistence.Models;

namespace FinkiChattery.Persistence.Configurations
{
    public class AnswerResponseConfig : BaseConfig<AnswerResponse>
    {
        public AnswerResponseConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<AnswerResponse> builder)
        {
            base.Configure(builder);

            builder.ToTable("AnswerResponse", Schema);

            builder.Property(x => x.Text).HasColumnName(@"Text").HasColumnType("nvarchar").IsRequired().HasMaxLength(4000);
            builder.Property(x => x.AnswerFk).HasColumnName(@"AnswerFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.StudentFk).HasColumnName(@"StudentFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.CreatedOn).HasColumnName(@"CreatedOn").HasColumnType("smalldatetime").IsRequired();

            builder.HasOne(x => x.Answer).WithMany(x => x.AnswerResponses).HasForeignKey(x => x.AnswerFk).OnDelete(DeleteBehavior.Restrict);
            builder.HasOne(x => x.Student).WithMany().HasForeignKey(x => x.AnswerFk).OnDelete(DeleteBehavior.Restrict);
        }
    }
}
