﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using FinkiChattery.Persistence.Models;

namespace FinkiChattery.Persistence.Configurations
{
    public class QuestionCategoryConfig : BaseConfig<QuestionCategory>
    {
        public QuestionCategoryConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<QuestionCategory> builder)
        {
            base.Configure(builder);

            builder.ToTable("QuestionCategory", Schema);

            builder.Property(x => x.QuestionFk).HasColumnName(@"QuestionFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.CategoryFk).HasColumnName(@"CategoryFk").HasColumnType("bigint").IsRequired();

            builder.HasOne(x => x.Question).WithMany(x => x.QuestionCategories).HasForeignKey(x => x.QuestionFk).OnDelete(DeleteBehavior.Restrict);
            builder.HasOne(x => x.Category).WithMany().HasForeignKey(x => x.QuestionFk).OnDelete(DeleteBehavior.Restrict);
        }
    }
}
