import pandas as pd
from sqlalchemy import create_engine, text

def connect_to_database():
    # Create SQLAlchemy engine (adjust connection string as needed)
    connection_string = "postgresql://db_202425z_va_prj_izgradi_owner:36cb70bb0e32@localhost:9999/db_202425z_va_prj_izgradi"
    return create_engine(connection_string)

def login(engine):
    username = input("Enter username: ").strip()
    password = input("Enter password: ").strip()
    try:
        query = f"SELECT uid, privilegii FROM korisnik WHERE username = '{username}' AND pwd = '{password}'"
        df = pd.read_sql(query, engine)
        
        if not df.empty:
            return df.iloc[0]['uid'], df.iloc[0]['privilegii']
        else:
            print("Invalid username or password.")
            return None, None
    except Exception as e:
        print(f"Error during login: {e}")
        return None, None

def menu_admin():
    print("\nAdmin Menu")
    print("1. Nabavki za objekt")
    print("2. Insert into Nabavka")
    print("3. Get General Objekt Details")
    print("4. Get Dobavuvac Details")
    print("5. Get Podizveduvac Details")
    print("6. Insert into Dobavuvac")
    print("7. Custom Query")
    print("0. Exit")

def menu_1(): #supervisor menu  
    print("\nStored Procedure Menu")
    print("1. Unapproved Nabavki")
    print("2. Approved Nabavki")
    print("3. Approve Nabavka")
    print("4. Get Object Details")
    print("0. Exit")

def menu_2(): #subcontractor menu
    print("\nMenu")
    print("1. Insert into Nabavka")
    print("2. Get Object Details")
    print("0. Exit")

def call_inline_query(engine, sql_query):
    """Execute a query and print results if any."""
    try:
        df = pd.read_sql(text(sql_query), engine)
        if not df.empty:
            print("\nResults:")
            print(df.to_string(index=False))
        else:
            print("No results found.")
    except Exception as e:
        print(f"Error: {e}")

def available_dobavuvaci():
    engine = connect_to_database()
    query = "SELECT dobavuvac_ime FROM dobavuvac"
    df = pd.read_sql(query, engine)
    print(df)
    return df['dobavuvac_ime'].tolist()

def main():
    engine = connect_to_database()
    uid, privileges = login(engine)
    if uid is None or privileges is None:
        print("Login failed. Exiting...")
        return

    while True:
        if privileges == 0:  # ADMIN
            menu_admin()
            choice = input("Enter your choice: ").strip()
            if choice == "0":
                print("Exiting...")
                break

            elif choice == "1":
                objektid = input("Enter Objekt ID: ").strip()
                sql_query = f"""
                        SELECT 
                        o.objekt_id, 
                        nb.nabavka_id, 
                        nb.datum AS datum_na_nabavka, 
                        nb.predmet, 
                        nb.kolicina, 
                        nb.cena
                    FROM objekt o
                    JOIN nameneta_za nz ON nz.objekt_id = o.objekt_id
                    JOIN nabavka nb ON nb.nabavka_id = nz.nabavka_id
                    WHERE o.objekt_id = {objektid};
                """
                df = pd.read_sql(sql_query, con=engine)
                print(df)
            elif choice == "2":
                dobavuvaci = available_dobavuvaci()
                # Inlined procedure: InsertOrderWithRelations(...)
                try:
                    pod_id = int(input("Enter Podizveduvac ID: ").strip())
                    dobav_ime = input("Enter Dobavuvac Name: ").strip()
                    datum = input("Enter Date (YYYY-MM-DD): ").strip()
                    cena = float(input("Enter Price: ").strip())
                    kolicina = float(input("Enter Quantity: ").strip())
                    predmet = input("Enter Item Name: ").strip()
                except Exception as e:
                    print(f"Invalid input: {e}")
                    continue

                sql_query = f"""
                WITH new_order AS (
                    INSERT INTO nabavka(datum, cena, kolicina, predmet)
                    VALUES ('{datum}', {cena}, {kolicina}, '{predmet}')
                    RETURNING nabavka_id
                ),
                pobaruva_insert AS (
                    INSERT INTO pobaruva(nabavka_id, uid_p)
                    SELECT nabavka_id, {pod_id}
                    FROM new_order
                ),
                ispolnuva_insert AS (
                    INSERT INTO ispolnuva(nabavka_id, dobavuvac_ime)
                    SELECT nabavka_id, '{dobav_ime}'
                    FROM new_order
                )
                SELECT nabavka_id FROM new_order;
                """
                
                with engine.begin() as conn:
                    result = conn.execute(text(sql_query)).fetchone()
                    if result is None:
                        print("Error inserting order.")
                        continue
                print("Order inserted successfully.")

            elif choice == "3":
                # Inlined procedure: GetObjektDetails(input_Objekt_ID)
                # For simplicity only the first SELECT (general details) is inlined.
                try:
                    objekt_id = int(input("Enter Objekt ID: ").strip())
                except Exception as e:
                    print(f"Invalid Objekt ID: {e}")
                    continue
                sql_query = f"""
                SELECT 
                    o.objekt_id,
                    o.tip AS objekt_type,
                    o.adresa AS objekt_address,
                    vi.budzet AS objekt_budget,
                    n.nadzor_ime
                FROM objekt o
                LEFT JOIN vo_izgradba vi ON o.objekt_id = vi.objekt_id
                LEFT JOIN nadgleduva nd ON o.objekt_id = nd.objekt_id
                LEFT JOIN nadzor n ON nd.uid_n = n.uid
                WHERE o.objekt_id = {objekt_id}
                GROUP BY o.objekt_id, o.tip, o.adresa, vi.budzet, n.nadzor_ime;
                """
                call_inline_query(engine, sql_query)

            elif choice == "4":
                # Inlined procedure: GetDobavuvacDetails(input_Dobavuvac_Ime)
                # Only the basic supplier info is inlined.
                dobavuvac_name = input("Enter Dobavuvac Name: ").strip()
                sql_query = f"""
                SELECT 
                    d.dobavuvac_ime, 
                    d.klasa AS klasa_na_dobavuvac, 
                    d.tip AS tip_na_dobavuvac, 
                    d.poteklo AS poteklo_na_dobavuvac
                FROM dobavuvac d
                WHERE d.dobavuvac_ime = '{dobavuvac_name}';
                """
                call_inline_query(engine, sql_query)


            elif choice == "5":
                sql_query = f"""
                SELECT 
                    p.podizveduvac_ime,
                    p.struka,
                    p.br_vraboteni,
                    p.saatnica
                FROM podizveduvac p;
                """
                call_inline_query(engine, sql_query)

            elif choice == "6":
                dobavuvac_name = input("Enter Dobavuvac Name: ").strip()
                dobavuvac_class = input("Enter Dobavuvac Class (A/B/C): ").strip()
                dobavuvac_type = input("Enter Dobavuvac Type: ").strip()
                dobavuvac_origin = input("Enter Dobavuvac Origin: ").strip()

                sql_query = f"""
                INSERT INTO Dobavuvac (Dobavuvac_Ime, Klasa, Tip, Poteklo)
                VALUES ('{dobavuvac_name}', '{dobavuvac_class}', '{dobavuvac_type}', '{dobavuvac_origin}');
                """
                try:
                    with engine.begin() as conn:
                        conn.execute(text(sql_query))
                    print("Dobavuvac inserted successfully.")
                except Exception as e:
                    print(f"Error inserting dobavuvac: {e}")

                
            elif choice == "7":
                query = input("Enter query: ")

                if query.startswith("SELECT"):
                    call_inline_query(engine, query)
                else:
                    try:
                        with engine.begin() as conn:
                            conn.execute(text(query))
                    except Exception as e:
                        print(f"Error executing query: {e}")

            
            else:
                print("Invalid choice. Please try again.")

            

        elif privileges == 1:  # SUPERVISOR
            menu_1()
            choice = input("Enter your choice: ").strip()
            if choice == "0":
                print("Exiting...")
                break

            elif choice == "1":
                # Inlined: Display_Nabavki_For_Nadzor (all unapproved orders)
                sql_query = f"""
                WITH select_objekt_nabavki AS (
                    SELECT 
                        o.objekt_id, 
                        nb.nabavka_id, 
                        nb.datum AS datum_na_nabavka, 
                        nb.predmet, 
                        nb.kolicina, 
                        nb.cena
                    FROM objekt o
                    JOIN nadgleduva n ON o.objekt_id = n.objekt_id
                    JOIN nameneta_za nz ON nz.objekt_id = o.objekt_id
                    JOIN nabavka nb ON nb.nabavka_id = nz.nabavka_id
                    WHERE n.uid_n = {uid}
                )
                SELECT * 
                FROM select_objekt_nabavki son
                LEFT JOIN odobruva o ON son.nabavka_id = o.nabavka_id;
                """
                call_inline_query(engine, sql_query)

            elif choice == "2":
                # Inlined (the second part of Display_Nabavki_For_Nadzor)
                sql_query = f"""
                WITH select_objekt_nabavki AS (
                    SELECT 
                        o.objekt_id, 
                        nb.nabavka_id, 
                        nb.datum AS datum_na_nabavka, 
                        nb.predmet, 
                        nb.kolicina, 
                        nb.cena
                    FROM objekt o
                    JOIN nadgleduva n ON o.objekt_id = n.objekt_id
                    JOIN nameneta_za nz ON nz.objekt_id = o.objekt_id
                    JOIN nabavka nb ON nb.nabavka_id = nz.nabavka_id
                    WHERE n.uid_n = {uid}
                )
                SELECT * 
                FROM select_objekt_nabavki son
                LEFT JOIN odobruva o ON son.nabavka_id = o.nabavka_id
                WHERE o.nabavka_id IS NOT NULL;
                """
                call_inline_query(engine, sql_query)

            elif choice == "3":
                nabavka_id = input("Enter Nabavka ID: ").strip()
                sql_query = f"""
                INSERT INTO odobruva (nabavka_id, uid_n)
                VALUES ({nabavka_id}, {uid});
                """
                call_inline_query(engine, sql_query)

            elif choice == "4":
            
                objekt_id = input("Enter Objekt ID: ").strip()
                sql_query = f"""
                SELECT 
                    o.objekt_id,
                    o.tip AS objekt_type,
                    o.adresa AS objekt_address,
                    vi.budzet AS objekt_budget,
                    n.nadzor_ime
                FROM objekt o
                LEFT JOIN vo_izgradba vi ON o.objekt_id = vi.objekt_id
                LEFT JOIN nadgleduva nd ON o.objekt_id = nd.objekt_id
                LEFT JOIN nadzor n ON nd.uid_n = n.uid
                WHERE o.objekt_id = {objekt_id}
                GROUP BY o.objekt_id, o.tip, o.adresa, vi.budzet, n.nadzor_ime;
                """
                call_inline_query(engine, sql_query)

                
            else:
                print("Invalid choice. Please try again.")

        elif privileges == 2:  # SUBCONTRACTOR
            menu_2()
            choice = input("Enter your choice: ").strip()
            if choice == "0":
                print("Exiting...")
                break

            elif choice == "1":
                # Inlined InsertOrderWithRelations procedure for subcontractor
                dobavuvaci = available_dobavuvaci()
                # Inlined procedure: InsertOrderWithRelations(...)
                try:
                    pod_id = int(input("Enter Podizveduvac ID: ").strip())
                    dobav_ime = input("Enter Dobavuvac Name: ").strip()
                    datum = input("Enter Date (YYYY-MM-DD): ").strip()
                    cena = float(input("Enter Price: ").strip())
                    kolicina = float(input("Enter Quantity: ").strip())
                    predmet = input("Enter Item Name: ").strip()
                except Exception as e:
                    print(f"Invalid input: {e}")
                    continue

                sql_query = f"""
                WITH new_order AS (
                    INSERT INTO nabavka(datum, cena, kolicina, predmet)
                    VALUES ('{datum}', {cena}, {kolicina}, '{predmet}')
                    RETURNING nabavka_id
                ),
                pobaruva_insert AS (
                    INSERT INTO pobaruva(nabavka_id, uid_p)
                    SELECT nabavka_id, {pod_id}
                    FROM new_order
                ),
                ispolnuva_insert AS (
                    INSERT INTO ispolnuva(nabavka_id, dobavuvac_ime)
                    SELECT nabavka_id, '{dobav_ime}'
                    FROM new_order
                )
                SELECT nabavka_id FROM new_order;
                """
                
                with engine.begin() as conn:
                    result = conn.execute(text(sql_query)).fetchone()
                    if result is None:
                        print("Error inserting order.")
                        continue
                print("Order inserted successfully.")

            elif choice == "2":
                
                objekt_id = int(input("Enter Objekt ID: ").strip())
                sql_query = f"""
                    SELECT 
                        o.objekt_id,
                        o.tip AS objekt_type,
                        o.adresa AS objekt_address,
                        vi.budzet AS objekt_budget,
                        n.nadzor_ime
                    FROM objekt o
                    LEFT JOIN vo_izgradba vi ON o.objekt_id = vi.objekt_id
                    LEFT JOIN nadgleduva nd ON o.objekt_id = nd.objekt_id
                    LEFT JOIN nadzor n ON nd.uid_n = n.uid
                    WHERE o.objekt_id = {objekt_id};
                    """
                call_inline_query(engine, sql_query)

            else:
                print("Invalid choice. Please try again.")

        else:
            print("Invalid permissions level.")
            break

if __name__ == "__main__":
    main()
