const bcrypt = require('bcryptjs');
const pool = require('../models/db'); 

exports.signup = async (req, res) => {
  const { name, surname, email, address, contact, password } = req.body;

  const result = await pool.query("SELECT * FROM customer WHERE email = $1", [email]);
  if (result.rows.length > 0) return res.send("Email already registered.");

  const hashedPassword = await bcrypt.hash(password, 10);
  const idResult = await pool.query("SELECT MAX(customerid)+1 AS newid FROM customer");
  const newID = idResult.rows[0].newid || 1;

  await pool.query(
    `INSERT INTO customer (customerid, customername, customersurname, email, address, customercontact, password) 
     VALUES ($1, $2, $3, $4, $5, $6, $7)`,
    [newID, name, surname, email, address, contact, hashedPassword]
  );

  res.send("Registration successful. <a href='/login.html'>Login here</a>.");
};

exports.login = async (req, res) => {
  const { email, password } = req.body;

  const customerResult = await pool.query("SELECT * FROM customer WHERE email = $1", [email]);
  const customer = customerResult.rows[0];

  if (customer && await bcrypt.compare(password, customer.password)) {
    req.session.user = {
      type: "customer",
      id: customer.customerid,
      name: customer.customername
    };
    return res.redirect("/index.html");
  }

  const employeeResult = await pool.query("SELECT * FROM employee WHERE email = $1", [email]);
  const employee = employeeResult.rows[0];

  if (employee && password === employee.password) {
    req.session.user = {
      type: "employee",
      id: employee.employeeid,
      name: employee.employeename,
      department: employee.department
    };
    return res.redirect("/index.html");
  }

  res.send("Invalid credentials.");
};

exports.logout = (req, res) => {
  req.session.destroy(err => {
    if (err) return res.status(500).send("Logout failed.");
    res.clearCookie("connect.sid");
    res.redirect("/login.html");
  });
};
