PRAGMA foreign_keys = ON;

INSERT OR IGNORE INTO tenants (id, name, owner_email, created_at)
VALUES (1, 'test-tenant', 'admin@test.local', datetime('now'));

INSERT OR IGNORE INTO users (id, email, name, picture, created_at)
VALUES (1, 'admin@test.local', 'Admin User', '', datetime('now'));

INSERT OR IGNORE INTO memberships (user_id, tenant_id, role, created_at)
VALUES (1, 1, 'admin', datetime('now'));

INSERT OR IGNORE INTO environments (name, created_at, tenant_id)
VALUES
  ('default', datetime('now'), 1),
  ('lab', datetime('now'), 1),
  ('production', datetime('now'), 1);

INSERT OR IGNORE INTO admin_sessions (token, created_at, tenant_id)
VALUES
  ('ADMIN_TEST_TOKEN_1', datetime('now'), 1),
  ('ADMIN_TEST_TOKEN_2', datetime('now'), 1);

INSERT OR IGNORE INTO env_tokens (env_name, token, created_at, expires_at, tenant_id)
VALUES
  ('default', 'ENV_TOKEN_DEFAULT_TEST', datetime('now'), datetime('now', '+15 minutes'), 1),
  ('lab', 'ENV_TOKEN_LAB_TEST', datetime('now'), datetime('now', '+15 minutes'), 1);

INSERT OR IGNORE INTO computers
(name, user, ip, os, first_seen, last_seen, sysmon_available, env_name, tenant_id)
VALUES
('PC-ADMIN', 'admin', '192.168.1.10', 'Windows 11 Pro',
 datetime('now','-2 days'), datetime('now'), 1, 'default', 1),

('DEV-LAPTOP', 'developer', '192.168.1.20', 'Ubuntu 22.04',
 datetime('now','-1 day'), datetime('now'), 1, 'lab', 1),

('OFFICE-PC', 'office_user', '192.168.1.30', 'Windows 10',
 datetime('now','-5 hours'), datetime('now'), 0, 'production', 1);


INSERT INTO computer_history
(computer_id, cpu_usage, ram_usage, disk_usage, network_sent_mb, network_recv_mb, timestamp)
VALUES
((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 35.5, 60.2, 70.1, 120.5, 98.2, datetime('now','-30 minutes')),
((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 42.0, 63.1, 71.0, 130.0, 102.3, datetime('now','-10 minutes')),

((SELECT id FROM computers WHERE tenant_id=1 AND name='DEV-LAPTOP'), 55.0, 70.4, 65.3, 210.7, 180.9, datetime('now','-20 minutes')),
((SELECT id FROM computers WHERE tenant_id=1 AND name='DEV-LAPTOP'), 60.3, 72.8, 66.0, 220.1, 190.0, datetime('now','-5 minutes'));

INSERT INTO computer_processes
(computer_id, pid, name, cpu_percent, memory_mb, username, cmdline, timestamp)
VALUES
((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 1234, 'chrome.exe', 12.5, 350.2, 'admin',
 'C:\Program Files\Google\Chrome\Application\chrome.exe', datetime('now','-15 minutes')),

((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 5678, 'powershell.exe', 5.2, 120.0, 'admin',
 'powershell -ExecutionPolicy Bypass', datetime('now','-10 minutes')),

((SELECT id FROM computers WHERE tenant_id=1 AND name='DEV-LAPTOP'), 2222, 'python3', 30.8, 250.4, 'developer',
 'python3 client.py', datetime('now','-8 minutes'));

INSERT INTO sysmon_events
(computer_id, event_id, event_type, message, timestamp, details)
VALUES
((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 1, 'Process Create',
 'Process created: chrome.exe', datetime('now','-12 minutes'),
 '{"ProcessName":"chrome.exe","User":"admin"}'),

((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 3, 'Network Connection',
 'Outbound connection established', datetime('now','-11 minutes'),
 '{"DestinationIp":"8.8.8.8","DestinationPort":443}'),

((SELECT id FROM computers WHERE tenant_id=1 AND name='DEV-LAPTOP'), 1, 'Process Create',
 'Process created: python3', datetime('now','-7 minutes'),
 '{"ProcessName":"python3","User":"developer"}');

INSERT INTO network_connections
(computer_id, pid, local_address, remote_address, status, process_name, timestamp)
VALUES
((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 1234,
 '192.168.1.10:51234', '8.8.8.8:443', 'ESTABLISHED', 'chrome.exe', datetime('now','-10 minutes')),

((SELECT id FROM computers WHERE tenant_id=1 AND name='DEV-LAPTOP'), 2222,
 '192.168.1.20:40122', '34.117.59.81:80', 'ESTABLISHED', 'python3', datetime('now','-6 minutes'));

INSERT INTO security_alerts
(computer_id, alert_type, severity, description, timestamp, resolved)
VALUES
((SELECT id FROM computers WHERE tenant_id=1 AND name='PC-ADMIN'), 'Suspicious Network Activity', 'HIGH',
 'Multiple outbound connections detected', datetime('now','-9 minutes'), 0),

((SELECT id FROM computers WHERE tenant_id=1 AND name='DEV-LAPTOP'), 'High CPU Usage', 'MEDIUM',
 'CPU usage exceeded 60%', datetime('now','-5 minutes'), 1);
