INSERT INTO users (first_name, last_name, email, password, role) VALUES
('Ana', 'Adminova', 'ana.admin@oplms.com', 'pass123', 'ADMIN'),
('Ivan', 'Instruktorov', 'ivan.instructor@oplms.com', 'pass123', 'INSTRUCTOR'),
('Elena', 'Instruktorka', 'elena.instructor@oplms.com', 'pass123', 'INSTRUCTOR'),
('Marko', 'Userov', 'marko.user@oplms.com', 'pass123', 'USER'),
('Sara', 'Userova', 'sara.user@oplms.com', 'pass123', 'USER'),
('Dalia', 'Userova', 'dalia.user@oplms.com', 'pass123', 'USER');


INSERT INTO subscription_plan (name, price, duration_months, description, access_type) VALUES
('Basic', 9.99, 1, 'Access to basic courses', 'BASIC'),
('Pro', 19.99, 1, 'Access to all courses', 'FULL'),
('Annual Pro', 199.99, 12, 'Full access for 12 months', 'FULL');


INSERT INTO user_subscription (user_id, plan_id, start_date, end_date, status) VALUES
(4, 2, '2025-12-01', '2025-12-31', 'ACTIVE'), 
(5, 1, '2025-12-05', '2026-01-05', 'ACTIVE'); 


INSERT INTO payment (user_id, subscription_id, amount) VALUES
(4, 1, 19.99),
(5, 2, 9.99);


INSERT INTO support_ticket (user_id, admin_id, subject, description, status)
VALUES
(4, 1, 'Payment issue', 'My payment shows pending.', 'OPEN'),
(5, 1, 'Course access', 'I cannot access one course.', 'IN_PROGRESS');


INSERT INTO category (name, description) VALUES
('Programming', 'Programming related courses'),
('Databases', 'SQL, relational design and normalization'),
('Networks', 'Networking fundamentals and security');


INSERT INTO course (name, price, status, instructor_id) VALUES
('SQL Fundamentals', 0.00, 'ACTIVE', 2),
('Database Design (ER -> Relational)', 29.99, 'ACTIVE', 2),
('Network Security Basics', 19.99, 'ACTIVE', 3);


INSERT INTO course_category (course_id, category_id) VALUES
(1, 2),
(2, 2),
(3, 3);


INSERT INTO module (course_id, title, description) VALUES
(1, 'Intro to SQL', 'Basics of SELECT, WHERE, ORDER BY'),
(1, 'Joins', 'INNER/LEFT JOIN and practice'),
(2, 'ER Modeling', 'Entities, relationships, cardinalities'),
(2, 'Relational Mapping', 'Transform ER to tables, PK/FK'),
(3, 'Security Concepts', 'CIA, threats, authentication');


INSERT INTO quiz (total_points, passing_score) VALUES
(100, 60),
(50, 30),
(80, 50);


INSERT INTO lesson (module_id, quiz_id, title, material) VALUES
(1, 1, 'SQL SELECT basics', 'Intro material for SELECT'),
(2, 1, 'JOIN examples', 'Practice joins with examples'),
(3, 2, 'ER entities and attributes', 'How to identify entities'),
(4, 2, 'Mapping rules', 'Rules for PK/FK and relations'),
(5, 3, 'Security overview', 'Basic security principles');


INSERT INTO enrollment (user_id, course_id, enroll_date, completion_status, progress_percentage) VALUES
(4, 2, '2025-12-10', 'IN_PROGRESS', 70), 
(5, 1, '2025-12-12', 'IN_PROGRESS', 40); 




INSERT INTO quiz_attempt (user_id, quiz_id, score)
VALUES (4, 2, 40);


INSERT INTO quiz_attempt (user_id, quiz_id, score)
VALUES (5, 1, 45);


UPDATE enrollment
SET completion_status = 'COMPLETED',
    progress_percentage = 100
WHERE enrollment_id = 1;

UPDATE enrollment
SET completion_status = 'IN_PROGRESS',
    progress_percentage = 40
WHERE enrollment_id = 2;


INSERT INTO certificate (enrollment_id, issue_date, certificate_code, status)
VALUES (1, '2025-12-20', 'CERT-DB-2025-0001', 'ISSUED');