package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/locals")
public class LocalController {

    private final LocalService localService;

    public LocalController(LocalService localService) {
        this.localService = localService;
    }

    @GetMapping
    public ResponseEntity<?> getLocals() {
        return new ResponseEntity<>(localService.listAll(), HttpStatus.OK);
    }

    @GetMapping("/{id}")
    public ResponseEntity<?> getLocalInformation(@PathVariable Long id) {
        Local local = localService.getLocalById(id);
        return new ResponseEntity<>(local, HttpStatus.OK);
    }
}
