package mk.ukim.finki.it.reservengo.dto.reservationDTO;

import mk.ukim.finki.it.reservengo.model.domain.Reservation;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.time.LocalDateTime;
import java.util.List;

public record DisplayReservationDTO(
        Long id,
        String localName,
        String localLogo,
        LocalDateTime timeOfReservation,
        Integer capacity,
        String description,
        ReservationStatus status
) {

    public static DisplayReservationDTO from(Reservation reservation) {
        return new DisplayReservationDTO(
                reservation.getId(),
                reservation.getLocal().getName(),
                reservation.getLocal().getLogoUrl(),
                reservation.getTimeOfReservation(),
                reservation.getTable().getCapacity(),
                reservation.getTable().getDescription(),
                reservation.getStatus()
        );
    }

    public static List<DisplayReservationDTO> from(List<Reservation> reservations) {
        return reservations.stream()
                .map(DisplayReservationDTO::from)
                .toList();
    }
}
