package mk.ukim.finki.it.reservengo.dto.workerDTO;

import mk.ukim.finki.it.reservengo.model.domain.Reservation;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.time.LocalDateTime;
import java.util.List;

public record DisplayLocalReservationDTO(
        Long reservationId,
        String customerName,
        Long customerId,
        LocalDateTime timeOfReservation,
        Integer tableCapacity,
        ReservationStatus reservationStatus
) {
    public static DisplayLocalReservationDTO from(Reservation reservation) {
        return new DisplayLocalReservationDTO(
                reservation.getId(),
                reservation.getCustomer().getFirstName(),
                reservation.getCustomer().getId(),
                reservation.getTimeOfReservation(),
                reservation.getTable().getCapacity(),
                reservation.getStatus()
        );
    }

    public static List<DisplayLocalReservationDTO> from(List<Reservation> reservations) {
        return reservations.stream()
                .map(DisplayLocalReservationDTO::from)
                .toList();
    }
}
