package mk.ukim.finki.it.reservengo.repository;

import mk.ukim.finki.it.reservengo.model.domain.Reservation;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

@Repository
public interface ReservationRepository extends JpaRepository<Reservation, Long> {

    List<Reservation> findByLocalId(Long id);

    List<Reservation> findByLocalIdAndStatus(Long id, ReservationStatus status);

    @Modifying
    @Query("UPDATE Reservation r SET r.status = 'EXPIRED' WHERE r.timeOfReservation < :now AND r.status NOT IN ('CANCELED', 'EXPIRED', 'FINISHED')")
    void expireOldReservations(@Param("now") LocalDateTime now);
}
