package mk.ukim.finki.it.reservengo.service.intf;

import mk.ukim.finki.it.reservengo.dto.customerDTO.RatingDTO;
import mk.ukim.finki.it.reservengo.dto.eventDTO.DisplayEventDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDTO;
import mk.ukim.finki.it.reservengo.dto.reservationDTO.*;
import mk.ukim.finki.it.reservengo.model.domain.Customer;

import java.util.List;

public interface CustomerService {

    List<DisplayLocalDTO> listFavouriteLocals(Long id);

    void addFavouriteLocal(Long userId, Long localId);

    void removeFavouriteLocal(Long userId, Long localId);

    void save(Customer customer);

    List<DisplayEventDTO> listFavouriteEvents(Long id);

    void addFavouriteEvent(Long userId, Long eventId);

    void removeFavouriteEvent(Long userId, Long eventId);

    void rateLocal(Long customerId, Long localId, RatingDTO ratingDTO);

    void removeRating(Long customerId, Long localId);

    int findLocalRating(Long customerId, Long localId);

    List<DisplayReservationDTO> listAllReservations(Long id);

    DisplayReservationDTO getReservationPreview(Long customerId, Long reservationId);

    DisplayReservationDTO editReservation(Long id, Long reservationId, EditReservationDTO editReservationDTO);

    void cancelReservation(Long id, Long reservationId);

    void makeReservation(Long id, Long localId,CreateReservationDTO createReservationDTO);

    void deleteReservation(Long id, DeleteReservationDTO deleteReservationDTO);
}
