import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class CustomerRepository {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  // FAVOURITES
  getFavouriteLocals(): Promise<any[]> {
    return this.httpClient.get('favourite-locals')
  }
  addFavourite(localId: number | string): Promise<any> {
    return this.httpClient.post(`favourite-locals/add/${localId}`, {})
  }
  removeFavourite(localId: number | string): Promise<any> {
    return this.httpClient.post(`favourite-locals/remove/${localId}`, {})
  }

  getFavouriteEvent(): Promise<any> {
    return this.httpClient.get(`favourite-events`)
  }
  addFavouriteEvent(eventId: number | string): Promise<any> {
    return this.httpClient.post(`favourite-events/add/${eventId}`)
  }

  removeFavouriteEvent(eventId: number | string): Promise<any> {
    return this.httpClient.post(`favourite-events/remove/${eventId}`)
  }

  // RATINGS
  getRatingForLocal(localId: number | string): Promise<any> {
    return this.httpClient.get(`local/${localId}/rating`)
  }
  rateLocal(localId: number | string, rating: number): Promise<any> {
    return this.httpClient.put(`local/${localId}/rate`, { rating })
  }
  removeRating(localId: number | string): Promise<any> {
    return this.httpClient.delete(`local/${localId}/remove-rating`)
  }
}

export const useCustomer = new CustomerRepository(BASE_API_URL + '/api/customer')
