package mk.ukim.finki.it.reservengo.config;

import com.twilio.Twilio;
import jakarta.annotation.PostConstruct;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix = "twilio")
@Data
public class TwilioConfig {
    private String sid;
    private String token;
    private String number;

    @PostConstruct
    public void init() {
        Twilio.init(sid, token);
    }
}

