package mk.ukim.finki.it.reservengo.service.impl;

//import com.twilio.rest.api.v2010.account.Message;
//import com.twilio.type.PhoneNumber;
//import mk.ukim.finki.it.reservengo.config.InfobipConfig;
//import mk.ukim.finki.it.reservengo.config.TwilioConfig;
//import mk.ukim.finki.it.reservengo.service.intf.SmsService;
//import org.springframework.http.MediaType;
//import org.springframework.stereotype.Service;
//import org.springframework.web.client.RestTemplate;

//import java.net.http.HttpHeaders;
//import java.util.Map;

import mk.ukim.finki.it.reservengo.config.InfobipConfig;
import mk.ukim.finki.it.reservengo.service.intf.SmsService;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

@Service
public class SmsServiceImpl implements SmsService {
    //    private final TwilioConfig config;
//
//    public SmsServiceImpl(TwilioConfig config) {
//        this.config = config;
//    }
//
//    public void sendSms(String to, String text) {
//        Message.creator(
//                new PhoneNumber(to),
//                new PhoneNumber(config.getNumber()),
//                text
//        ).create();
//    }
    private final InfobipConfig config;
    private final RestTemplate restTemplate = new RestTemplate();

    public SmsServiceImpl(InfobipConfig config) {
        this.config = config;
    }

    @Override
    public void sendSms(String to, String text) {

        String url = config.getBase() + "/sms/2/text/advanced";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "App " + config.getKey());

        Map<String, Object> body = Map.of(
                "messages", List.of(
                        Map.of(
                                "from", config.getSender(),
                                "destinations", List.of(
                                        Map.of("to", to)
                                ),
                                "text", text
                        )
                )
        );

        HttpEntity<Map<String, Object>> entity =
                new HttpEntity<>(body, headers);

        restTemplate.postForEntity(url, entity, String.class);
    }

}
