package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.dto.jwtDTO.JWTAuthenticationRequestDTO;
import mk.ukim.finki.it.reservengo.dto.jwtDTO.JWTAuthenticationResponseDTO;
import mk.ukim.finki.it.reservengo.dto.jwtDTO.JWTLoginDTO;
import mk.ukim.finki.it.reservengo.service.intf.AuthService;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/auth")
public class AuthController {
    private final AuthService authenticationService;

    public AuthController(AuthService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value = "/register/customer", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<JWTAuthenticationResponseDTO> registerCustomer(@RequestBody JWTAuthenticationRequestDTO jwtAuthenticationRequestDTO) {
        return new ResponseEntity<>(authenticationService.registerCustomer(jwtAuthenticationRequestDTO), HttpStatus.CREATED);
    }

    @PostMapping("/register/local-worker")
    public ResponseEntity<JWTAuthenticationResponseDTO> registerLocalWorker(@RequestBody JWTAuthenticationRequestDTO jwtAuthenticationRequestDTO) {
        return new ResponseEntity<>(authenticationService.registerLocalWorker(jwtAuthenticationRequestDTO), HttpStatus.CREATED);
    }

    @PostMapping("/register/local-manager")
    public ResponseEntity<JWTAuthenticationResponseDTO> registerLocalManager(@RequestBody JWTAuthenticationRequestDTO jwtAuthenticationRequestDTO) {
        return new ResponseEntity<>(authenticationService.registerLocalManager(jwtAuthenticationRequestDTO), HttpStatus.CREATED);
    }

    @PostMapping("/login")
    public ResponseEntity<JWTAuthenticationResponseDTO> login(@RequestBody JWTLoginDTO jwtLoginDTO) {
        return new ResponseEntity<>(authenticationService.login(jwtLoginDTO), HttpStatus.OK);
    }
}
