package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.domain.Customer;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.exceptions.CustomerNotFoundException;
import mk.ukim.finki.it.reservengo.repository.CustomerRepository;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustomerServiceImpl implements CustomerService {
    private final CustomerRepository customerRepository;
    private final LocalService localService;

    public CustomerServiceImpl(CustomerRepository customerRepository, LocalService localService) {
        this.customerRepository = customerRepository;
        this.localService = localService;
    }

    @Override
    public Customer getCustomerProfile(Long id) {
        return customerRepository.findById(id).orElseThrow(() -> new CustomerNotFoundException(id));
    }

    @Override
    public List<Local> listFavouriteLocals(Long id) {
        Customer customer = customerRepository.findById(id).orElseThrow(() -> new CustomerNotFoundException(id));
        return customer.getFavouriteLocals();
    }

    @Override
    public void addFavouriteLocal(Long userId, Long localId) {
        Customer customer = customerRepository.findById(userId).orElseThrow(() -> new CustomerNotFoundException(userId));
        Local local = localService.getLocalById(localId);

        if (!customer.getFavouriteLocals().contains(local)) {
            customer.getFavouriteLocals().add(local);
        }

        customerRepository.save(customer);
    }

    @Override
    public void removeFavouriteLocal(Long userId, Long localId) {
        Customer customer = customerRepository.findById(userId).orElseThrow(() -> new CustomerNotFoundException(userId));
        Local local = localService.getLocalById(localId);

        customer.getFavouriteLocals().remove(local);

        customerRepository.save(customer);
    }
}
