package mk.ukim.finki.it.reservengo.bootstrap;

import jakarta.annotation.PostConstruct;
import mk.ukim.finki.it.reservengo.model.domain.*;
import mk.ukim.finki.it.reservengo.model.enumerations.EventStatus;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;
import mk.ukim.finki.it.reservengo.model.enumerations.Service;
import mk.ukim.finki.it.reservengo.repository.*;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
public class DataHolder {
    public static Admin admin = null;
    public static List<Customer> customers = new ArrayList<>();
    public static List<LocalWorker> workers = new ArrayList<>();
    public static List<LocalManager> managers = new ArrayList<>();
    public static List<Local> locals = new ArrayList<>();
    public static List<Event> events = new ArrayList<>();

    private final AdminRepository adminRepository;
    private final CustomerRepository customerRepository;
    private final LocalManagerRepository localManagerRepository;
    private final LocalRepository localRepository;
    private final LocalWorkerRepository localWorkerRepository;
    private final PasswordEncoder passwordEncoder;
    private final EventRepository eventRepository;

    public DataHolder(AdminRepository adminRepository, CustomerRepository customerRepository, LocalManagerRepository localManagerRepository, LocalRepository localRepository, LocalWorkerRepository localWorkerRepository, PasswordEncoder passwordEncoder, EventRepository eventRepository) {
        this.adminRepository = adminRepository;
        this.customerRepository = customerRepository;
        this.localManagerRepository = localManagerRepository;
        this.localRepository = localRepository;
        this.localWorkerRepository = localWorkerRepository;
        this.passwordEncoder = passwordEncoder;
        this.eventRepository = eventRepository;
    }

    @PostConstruct
    public void init() {
        // Admin
        admin = new Admin("admin", passwordEncoder.encode("admin"), Role.ROLE_ADMIN);
        adminRepository.save(admin);

        // Customers
        for (int i = 1; i <= 3; i++) {
            Customer customer = new Customer(
                    "FirstName " + i,
                    "LastName " + i,
                    "customer" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_CUSTOMER
            );
            customers.add(customer);
        }
        customerRepository.saveAll(customers);

        //Local worker
        for (int i = 1; i <= 3; i++) {
            LocalWorker localWorker = new LocalWorker(
                    "FirstName" + i,
                    "LastName" + i,
                    "worker" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_LOCAL_WORKER
            );
            workers.add(localWorker);
        }
        localWorkerRepository.saveAll(workers);

        //Local manager
        for (int i = 1; i <= 3; i++) {
            LocalManager manager = new LocalManager(
                    "FirstName" + i,
                    "LastName" + i,
                    "manager" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_LOCAL_MANAGER
            );
            managers.add(manager);
        }
        localManagerRepository.saveAll(managers);

        //Local
        List<Service> serviceList = new ArrayList<>(List.of(Service.values()));
        List<String> localPhotos;
        for (int i = 1; i <= 3; i++) {
            localPhotos = new ArrayList<>();
            for (int j = 1; j <= 3; j++) {
                localPhotos.add("PicturePath: " + j);
            }
            Local local = new Local(
                    "Name" + i,
                    "Description" + i,
                    "Address" + i,
                    "WorkingHours" + i,
                    serviceList,
                    null,
                    null,
                    "LogoURL" + i,
                    localPhotos,
                    "MenuLink" + i,
                    null,
                    null,
                    null
            );
            locals.add(local);
        }
        localRepository.saveAll(locals);

        for (Local local : locals) {
            // Active event
            Event activeEvent = new Event(
                    "Active Event for " + local.getName(),
                    "Description for active event",
                    LocalDateTime.now().plusDays(7), // Future date
                    LocalDateTime.now().plusDays(8),
                    local,
                    EventStatus.ACTIVE
            );

            // Finished event
            Event finishedEvent = new Event(
                    "Finished Event for " + local.getName(),
                    "Description for finished event",
                    LocalDateTime.now().minusDays(7), // Past date
                    LocalDateTime.now().minusDays(6),
                    local,
                    EventStatus.FINISHED
            );

            events.add(activeEvent);
            events.add(finishedEvent);
        }
        eventRepository.saveAll(events);
    }
}