

import {defineStore} from 'pinia'


export const restaurantStore = defineStore('restaurantStore', {

  state(){
    return {
      id: '',
      name: '',
      description: '',
      address: '',
      workingHours: '',
      availableServices: [],
      ratingAvg: 0,
      events: [],
      restaurantPhotos: [],
      menuPhoto: '',
      menuLink: '',
      contact: '',
      logo: '',
    }
  },
  actions: {
    setRestaurant (id, name, description, address, workingHours, logo, averageRating) {
      this.id = id
      this.name = name
      this.description = description
      this.address = address
      this.workingHours = workingHours
      this.logo = logo
      this.ratingAvg = averageRating
    },
    setRestaurantDetails (id, name, description, address, workingHours, availableServices, averageRating, events, restaurantPhotos, menuPhoto, menuLink, contact, logo) {
      this.id=id;
      this.name = name;
      this.description = description
      this.address = address
      this.workingHours = workingHours
      this.availableServices = availableServices
      this.ratingAvg = averageRating
      this.events = events
      this.restaurantPhotos = restaurantPhotos
      this.menuPhoto = menuPhoto
      this.menuLink = menuLink
      this.contact = contact
      this.logo = logo
    },
    newRestaurant (id) {
      this.id = id
    },
    clearRestaurant () {
      this.setRestaurant(null)
    }
  },
  getters: {

  }



})
