package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.Reservation;
import mk.ukim.finki.it.reservengo.model.exceptions.ReservationNotFoundException;
import mk.ukim.finki.it.reservengo.repository.ReservationRepository;
import mk.ukim.finki.it.reservengo.service.intf.ReservationService;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class ReservationServiceImpl implements ReservationService {

    private final ReservationRepository reservationRepository;

    public ReservationServiceImpl(ReservationRepository reservationRepository) {
        this.reservationRepository = reservationRepository;
    }

    @Override
    public Reservation getReservationById(Long id) {
        return this.reservationRepository.findById(id).orElseThrow(() -> new ReservationNotFoundException(id));
    }

    @Override
    public List<Reservation> getCustomerReservations(Long id) {
        return this.reservationRepository.findAllByCustomerId(id);
    }

}
