package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.service.intf.EmailService;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl implements EmailService {
    private final JavaMailSender mailSender;

    private final String frontEndUrl = "http://localhost:5173";

    public EmailServiceImpl(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Override
    public void sendManagerInvitationEmail(String email, String token) {
        String invitationUrl = frontEndUrl + "/register/manager?token=" + token;

        SimpleMailMessage message = new SimpleMailMessage();
        message.setTo(email);
        message.setSubject("Manager Invitation");
        message.setText(String.format(
                """
                        You have been invited to become a manager.
                        
                        Click the link below to complete your registration:
                        %s
                        
                        This link will expire in 24 hours.""",
                invitationUrl
        ));

        mailSender.send(message);
    }

    @Override
    public void sendWorkerInvitationEmail(String email, String token, String managerEmail, String localName) {
        String invitationUrl = frontEndUrl + "/register/worker?token=" + token;

        SimpleMailMessage message = new SimpleMailMessage();
        message.setTo(email);
        message.setSubject("Worker Invitation");
        message.setText(String.format(
                """
                        You have been invited to become a worker at "%s".
                        
                        Invited by manager: %s
                        
                        Click the link below to complete your registration:
                        %s
                        
                        This link will expire in 24 hours.
                        """,
                localName,
                managerEmail,
                invitationUrl
        ));

        mailSender.send(message);
    }
}
