import { ApiClient } from '@/Api_Classes/ApiClient'
import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class Authentication {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  makeLogin(email: String, password: String) : Promise<any> {
    return this.httpClient.post('login', { email, password })
  }
  // Google OAuth login
  makeGoogleLogin(googleIdToken: String): Promise<any> {
    const headers: Record<string, any> = { 'X-Google-Token': googleIdToken }
    return this.httpClient.post('oauth/google/login', null, { headers })
  }
  makeRegister(
    firstName: String,
    lastName: String,
    email: String,
    phoneNumber: String,
    password: String,
    role: String,
    inviteToken?: String
  ) {
    return this.httpClient.post("register/" + role, { firstName, lastName, email, phoneNumber, password }, {headers: {'Invite-Token': inviteToken} })
  }
  verifyAccount(email: String, verificationCode: String) : Promise<any> {
    return this.httpClient.patch('verify', { email, verificationCode })
  }
  reEnableAccount(email: String, password: String) : Promise<any> {
    return this.httpClient.patch('enable', { email, password })
  }


  googleRegister(role: String, googleIdToken: String, inviteToken?: String): Promise<any> {
    const headers: Record<string, any> = { 'X-Google-Token': googleIdToken }
    if (inviteToken) headers['Invite-Token'] = inviteToken
    return this.httpClient.post(`oauth/google/${role}`, null, { headers })
  }
}

export const useAuth = new Authentication(BASE_API_URL + '/api/auth')
