package mk.ukim.finki.it.reservengo.dto.localDTO;

import mk.ukim.finki.it.reservengo.dto.contactDTO.ContactDTO;
import mk.ukim.finki.it.reservengo.dto.eventDTO.DisplayEventDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.enumerations.LocalType;
import mk.ukim.finki.it.reservengo.model.enumerations.ProvidedService;

import java.util.List;

public record DisplayLocalDetailsDTO(
        Long id,
        String name,
        String description,
        String address,
        List<WorkingHourDTO> workingHours,
        List<ProvidedService> services,
        Double ratingAvg,
        List<DisplayEventDTO> events, // ne gi vrakaj tuka eventite
        List<String> localPhotos,
        String menuLink,
        ContactDTO contact,
        String logo,
        LocalType localType
) {
    public static DisplayLocalDetailsDTO from(Local local) {
        return new DisplayLocalDetailsDTO(
                local.getId(),
                local.getName(),
                local.getDescription(),
                local.getAddress(),
                WorkingHourDTO.from(local.getWorkingHours()),
                local.getAvailableServices(),
                local.getAverageRating(),
                DisplayEventDTO.fromEvents(local.getEvents()),
                local.getPhotos(),
                local.getMenuLink(),
                ContactDTO.from(local.getContact()),
                local.getLogoUrl(),
                local.getLocalType()
        );
    }
}
