package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import lombok.*;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Entity
@NoArgsConstructor
@AllArgsConstructor
@Data
public class Customer extends User {
    public Customer(String firstName, String lastName, String email, String password, String phoneNumber, Role userRole) {
        super(firstName, lastName, email, password, phoneNumber, userRole);
    }

    @OneToMany(mappedBy = "customer", cascade = CascadeType.ALL)
    private List<Reservation> reservations;

    @ManyToMany
    private List<Local> favouriteLocals;

    @ManyToMany
    private List<Event> favouriteEvents;
}
